/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.inventory;

import net.minecraft.class_1263;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlotViewer;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiInventoryGridPreview
extends GuiParent {
    public final class_1263 container;
    protected boolean hasFixedSize = true;
    private int fixedSize;
    protected boolean reverse = false;
    private int cols;
    private int rows;
    private int cachedCols;
    private int cachedRows;

    public GuiInventoryGridPreview(String name, class_1263 container) {
        this(name, container, (int)Math.ceil(Math.sqrt(container.method_5439())));
        this.hasFixedSize = false;
    }

    public GuiInventoryGridPreview(String name, class_1263 container, int cols) {
        this(name, container, cols, (int)Math.ceil((double)container.method_5439() / (double)cols));
    }

    public GuiInventoryGridPreview(String name, class_1263 container, int cols, int rows) {
        super(name);
        this.cols = cols;
        this.rows = rows;
        this.container = container;
        this.fixedSize = Math.min(container.method_5439(), cols * rows);
        for (int i = 0; i < this.fixedSize; ++i) {
            GuiChildControl child = super.add(new GuiSlotViewer(container.method_5438(i)));
            child.rect.maxX = 18.0;
            child.rect.maxY = 18.0;
        }
    }

    @Override
    @Deprecated
    public GuiChildControl add(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMinWidth() {
        return this.hasFixedSize ? this.cols * 18 : 18;
    }

    @Override
    public int getMinHeight(int width) {
        return this.hasFixedSize ? this.rows * 18 : 18;
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedCols = width / 18;
        if (this.hasFixedSize) {
            this.cachedCols = Math.min(this.cachedCols, this.cols);
        }
        int offset = (width - this.cachedCols * 18) / 2;
        int i = 0;
        for (GuiChildControl control : this.controls) {
            control.setX(offset + i % this.cachedCols * 18);
            control.flowX();
            ++i;
        }
    }

    @Override
    public void flowY(int witdh, int height, int preferred) {
        this.cachedRows = height / 18;
        if (this.hasFixedSize) {
            this.cachedRows = Math.min(this.cachedRows, this.rows);
        }
        int offset = (height - this.cachedRows * 18) / 2;
        int i = this.reverse ? this.controls.size() - 1 : 0;
        for (GuiChildControl control : this.controls) {
            int row = i / this.cachedCols;
            control.setY(offset + row * 18);
            control.flowY();
            control.control.visible = row <= this.cachedRows;
            if (this.reverse) {
                --i;
                continue;
            }
            ++i;
        }
    }

    @Override
    protected int preferredWidth() {
        return this.cols * 18;
    }

    @Override
    protected int preferredHeight(int width) {
        return (int)Math.ceil((double)this.container.method_5439() / (double)this.cachedCols) * 18;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }
}

